
<?php $__env->startSection('title', 'Tambah Pelaporan Gangguan'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Tambah Pelaporan Gangguan</h3>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('pelaporangangguan.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama">Nama Pelanggan *</label>
                                <select name="nama" id="nama" class="form-control select2" required>
                                    <option value="">Pilih Pelanggan</option>
                                    <?php $__currentLoopData = $pelanggans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelanggan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($pelanggan->nama); ?>"
                                        data-alamat="<?php echo e($pelanggan->alamat ?? ''); ?>"
                                        data-hp="<?php echo e($pelanggan->hp ?? ''); ?>"
                                        <?php echo e(old('nama') == $pelanggan->nama ? 'selected' : ''); ?>>
                                        <?php echo e($pelanggan->nama); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="alamat">Alamat</label>
                                <input type="text" class="form-control" id="alamat" name="alamat" value="<?php echo e(old('alamat')); ?>" readonly>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hp">No HP</label>
                                <input type="text" class="form-control" id="hp" name="hp" value="<?php echo e(old('hp')); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jenis_gangguan">Jenis Gangguan</label>
                                <textarea class="form-control" id="jenis_gangguan" name="jenis_gangguan" rows="3"><?php echo e(old('jenis_gangguan')); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jam_ganguan">Jam Gangguan</label>
                                <input type="datetime-local" class="form-control" id="jam_ganguan" name="jam_ganguan" value="<?php echo e(old('jam_ganguan')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="penerima_laporan">Penerima Laporan *</label>
                                <select name="penerima_laporan" id="penerima_laporan" class="form-control select2" required>
                                    <option value="">Pilih Penerima Laporan</option>
                                    <?php $__currentLoopData = $penerimaLaporans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pengguna): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($pengguna->nama); ?>" <?php echo e(old('penerima_laporan') == $pengguna->nama ? 'selected' : ''); ?>>
                                        <?php echo e($pengguna->nama); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="waktu_mulai_penanganan">Waktu Mulai Penanganan</label>
                                <input type="datetime-local" class="form-control" id="waktu_mulai_penanganan" name="waktu_mulai_penanganan" value="<?php echo e(old('waktu_mulai_penanganan')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="petugas_teknisi">Petugas Teknisi *</label>
                                <select name="petugas_teknisi" id="petugas_teknisi" class="form-control select2" required>
                                    <option value="">Pilih Teknisi</option>
                                    <?php $__currentLoopData = $teknisis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teknisi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($teknisi->nama); ?>" <?php echo e(old('petugas_teknisi') == $teknisi->nama ? 'selected' : ''); ?>>
                                        <?php echo e($teknisi->nama); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="waktu_finish">Waktu Selesai</label>
                                <input type="datetime-local" class="form-control" id="waktu_finish" name="waktu_finish" value="<?php echo e(old('waktu_finish')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="foto1">Foto 1</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="foto1" name="foto1">
                                    <label class="custom-file-label" for="foto1">Pilih file</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="foto2">Foto 2</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="foto2" name="foto2">
                                    <label class="custom-file-label" for="foto2">Pilih file</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="keterangan">Keterangan</label>
                                <textarea class="form-control" id="keterangan" name="keterangan" rows="3"><?php echo e(old('keterangan')); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                        <a href="<?php echo e(route('pelaporangangguan.index')); ?>" class="btn btn-secondary">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Select2 and Input File Label Scripts -->
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize Select2
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        });

        // Update file label when file is selected
        $('.custom-file-input').change(function() {
            var fileName = $(this).val().split('\\').pop();
            $(this).next('.custom-file-label').addClass("selected").html(fileName);
        });

        // Function to update alamat and hp fields
        function updatePelangganFields() {
            var selectedOption = $('#nama').find('option:selected');
            // Use .attr() instead of .data() to get the raw attribute values
            var alamat = selectedOption.attr('data-alamat');
            var hp = selectedOption.attr('data-hp');

            $('#alamat').val(alamat ? alamat : '');
            $('#hp').val(hp ? hp : '');
        }

        // Handle regular change event
        $('#nama').on('change', function() {
            updatePelangganFields();
        });

        // Handle Select2 select event
        $('#nama').on('select2:select', function(e) {
            updatePelangganFields();
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/pelaporangangguan/create.blade.php ENDPATH**/ ?>