<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(url('/')); ?>" class="brand-link">
        <img src="<?php echo e(asset('adminlte/dist/img/AdminLTELogo.png')); ?>" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">BuildNet</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- User Panel -->
        <?php
        $user = Auth::user();
        $companyName = 'Superadmin';
        $companyLogo = asset('/images/logo.jpg'); // Default logo

        if ($user && $user->company_code !== '000') {
        $company = \App\Models\Company::where('company_code', $user->company_code)->first();
        if ($company) {
        $companyName = $company->nama_company;
        if (!empty($company->logo)) {
        $companyLogo = asset('storage/' . $company->logo);
        }
        }
        }
        ?>

        <div class="user-panel mt-3 pb-3 mb-3 d-flex align-items-center">
            <div class="image">
                <img src="<?php echo e($companyLogo); ?>" class="img-circle elevation-2" alt="User Image" style="width: 38px; height: 38px; object-fit: cover;">
            </div>
            <div class="info">
                <a href="<?php echo e(route('profile.edit')); ?>" class="d-block font-weight-bold"><?php echo e($user->nama ?? 'User'); ?></a>
                <span class="text-xs text-muted d-block"><?php echo e(Str::limit($companyName, 20)); ?></span>
            </div>
        </div>

        <!-- Sidebar Search Form -->
        <div class="form-inline">
            <form action="<?php echo e(route('pelanggan.index')); ?>" method="GET" class="w-100">
                <div class="input-group">
                    <input class="form-control form-control-sidebar" type="search" name="search" placeholder="Cari Pelanggan..." aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-sidebar" type="submit">
                            <i class="fas fa-search fa-fw"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column nav-flat nav-child-indent" data-widget="treeview" role="menu" data-accordion="false">

                <li class="nav-header">MENU UTAMA</li>

                <li class="nav-item">
                    <a href="<?php echo e(url('/dashboard')); ?>" class="nav-link <?php echo e(Request::is('dashboard') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p>
                    </a>
                </li>

                
                <?php
                $canReadCompany = $user && ($user->company_code === '000' || ($user->role && $user->role->hak_akses_tbl_company_read));
                $canReadRole = $user && ($user->company_code === '000' || ($user->role && $user->role->hak_akses_tbl_role_read));
                $canReadPengguna = $user && ($user->company_code === '000' || ($user->role && $user->role->hak_akses_tbl_pengguna_read));
                ?>

                <li class="nav-header">LAYANAN PELANGGAN</li>

                <li class="nav-item">
                    <a href="<?php echo e(route('pelanggan.index')); ?>" class="nav-link <?php echo e(request()->is('pelanggan*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-address-book"></i>
                        <p>Data Pelanggan</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('importdatapelanggan.index')); ?>" class="nav-link <?php echo e(request()->is('importdatapelanggan*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-file-import"></i>
                        <p>Import Pelanggan</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('pasangbaru.index')); ?>" class="nav-link <?php echo e(request()->is('pasangbaru*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-user-plus"></i>
                        <p>
                            Pasang Baru
                            <?php
                            // Check for 'belum' status as currently used in DB for this model
                            $queryPasang = \App\Models\PasangBaru::where('finish', 'belum');

                            if ($user && $user->company_code !== '000') {
                            $queryPasang->where('company_code', $user->company_code);
                            }
                            $pendingPasangBaruCount = $queryPasang->count();
                            ?>

                            <?php if($pendingPasangBaruCount > 0): ?>
                            <span class="badge badge-warning right"><?php echo e($pendingPasangBaruCount); ?></span>
                            <?php endif; ?>
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('pelaporangangguan.index')); ?>" class="nav-link <?php echo e(request()->is('pelaporangangguan*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-headset"></i>
                        <p>
                            Pelaporan Gangguan
                            <?php
                            $queryGangguan = \App\Models\PelaporanGangguan::where('finish', false);
                            if ($user && $user->company_code !== '000') {
                            $queryGangguan->where('company_code', $user->company_code);
                            }
                            $pendingGangguanCount = $queryGangguan->count();
                            ?>

                            <?php if($pendingGangguanCount > 0): ?>
                            <span class="badge badge-danger right"><?php echo e($pendingGangguanCount); ?></span>
                            <?php endif; ?>
                        </p>
                    </a>
                </li>

                <li class="nav-header">MASTER DATA</li>

                <li class="nav-item">
                    <a href="<?php echo e(route('product.index')); ?>" class="nav-link <?php echo e(request()->is('product*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-box-open"></i>
                        <p>Produk / Paket</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('metodepembayaran.index')); ?>" class="nav-link <?php echo e(request()->is('metodepembayaran*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-credit-card"></i>
                        <p>Metode Pembayaran</p>
                    </a>
                </li>

                <?php if($canReadCompany || $canReadRole || $canReadPengguna): ?>
                <li class="nav-header">ADMINISTRASI SISTEM</li>

                <?php if($canReadCompany): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('/company')); ?>" class="nav-link <?php echo e(Request::is('company*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-building"></i>
                        <p>Perusahaan</p>
                    </a>
                </li>
                <?php endif; ?>

                <?php if($canReadRole): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('/role')); ?>" class="nav-link <?php echo e(Request::is('role*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-user-shield"></i>
                        <p>Manajemen Role</p>
                    </a>
                </li>
                <?php endif; ?>

                <?php if($canReadPengguna): ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('pengguna.index')); ?>" class="nav-link <?php echo e(request()->is('pengguna*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-users"></i>
                        <p>Pengguna</p>
                    </a>
                </li>
                <?php endif; ?>

                <li class="nav-item">
                    <a href="<?php echo e(url('/backupdatabase')); ?>" class="nav-link <?php echo e(Request::is('backupdatabase*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-database"></i>
                        <p>Backup & Restore</p>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</aside><?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>