

<?php $__env->startSection('title', 'Data Company'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Data Company</h3>
                <?php if($canCreate): ?>
                <div class="card-tools">
                    <a href="<?php echo e(route('company.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Tambah
                    </a>
                </div>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <form action="<?php echo e(route('company.index')); ?>" method="GET" class="form-inline">
                            <label class="mr-2">Show</label>
                            <select name="limit" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                                <option value="40" <?php echo e(request('limit') == 40 ? 'selected' : ''); ?>>40</option>
                                <option value="50" <?php echo e(request('limit') == 50 ? 'selected' : ''); ?>>50</option>
                                <option value="100" <?php echo e(request('limit') == 100 ? 'selected' : ''); ?>>100</option>
                            </select>
                            <label>entries</label>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <form action="<?php echo e(route('company.index')); ?>" method="GET" class="float-right">
                            <input type="hidden" name="limit" value="<?php echo e(request('limit', 40)); ?>">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" name="search" class="form-control float-right" placeholder="Search" value="<?php echo e(request('search')); ?>">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Kode</th>
                                <th>Nama Company</th>
                                <th>Status</th>
                                <th>Expired At</th>
                                <th>Alamat</th>
                                <th>HP</th>
                                <th>Email</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr style="cursor: pointer;" onclick="if(!event.target.closest('.action-btn') <?php if($canEdit): ?> && true <?php else: ?> && false <?php endif; ?>) window.location='<?php echo e(route('company.edit', $company->id)); ?>';">
                                <td><?php echo e($loop->iteration + ($companies->currentPage() - 1) * $companies->perPage()); ?></td>
                                <td><?php echo e($company->company_code); ?></td>
                                <td><?php echo e($company->nama_company); ?></td>
                                <td><?php echo e($company->status); ?></td>
                                <td><?php echo e($company->expired_at ? $company->expired_at->format('d-m-Y') : '-'); ?></td>
                                <td><?php echo e($company->alamat); ?></td>
                                <td><?php echo e($company->hp); ?></td>
                                <td><?php echo e($company->email); ?></td>
                                <td class="action-btn">
                                    <?php if($canEdit): ?>
                                    <a href="<?php echo e(route('company.edit', $company->id)); ?>" class="btn btn-warning btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php endif; ?>
                                    <?php if($canDelete): ?>
                                    <form action="<?php echo e(route('company.destroy', $company->id)); ?>" method="POST" class="d-inline delete-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="button" class="btn btn-danger btn-sm btn-delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center">Data tidak ditemukan</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer clearfix">
                <?php echo e($companies->appends(['search' => request('search'), 'limit' => request('limit')])->links('vendor.pagination.custom')); ?>

            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.querySelectorAll('.btn-delete').forEach(button => {
        button.addEventListener('click', function() {
            let form = this.closest('form');
            Swal.fire({
                title: 'Apakah anda yakin?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/company/index.blade.php ENDPATH**/ ?>