<!DOCTYPE html>
<html lang="en">

<head>
  <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">


    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'AdminLTE'); ?></title>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="<?php echo e(asset('adminlte/plugins/fontawesome-free/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('adminlte/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('adminlte/dist/css/adminlte.min.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <?php echo $__env->yieldPushContent('styles'); ?>
  </head>

<body class="hold-transition sidebar-mini">
  <div class="wrapper">

    <?php echo $__env->make('layouts.partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php echo $__env->make('layouts.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="content-wrapper">

      <section class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1><?php echo $__env->yieldContent('title'); ?></h1>
            </div>
            <div class="col-sm-6">
              
        <ol class="breadcrumb float-sm-right">
            <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($loop->last): ?>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($item['name']); ?></li>
                <?php else: ?>
                    <li class="breadcrumb-item"><a href="<?php echo e($item['url']); ?>"><?php echo e($item['name']); ?></a></li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ol>


            </div>
          </div>
        </div>
      </section>

      <section class="content">
        <?php echo $__env->yieldContent('content'); ?>
      </section>

    </div>

    <?php echo $__env->make('layouts.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <aside class="control-sidebar control-sidebar-dark"></aside>
  </div>

  <script src="<?php echo e(asset('adminlte/plugins/jquery/jquery.min.js')); ?>"></script>
  <script src="<?php echo e(asset('adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('adminlte/plugins/select2/js/select2.full.min.js')); ?>"></script>
  <script src="<?php echo e(asset('adminlte/dist/js/adminlte.min.js')); ?>"></script>




  <script>
    $(function() {
      $('.select2').select2();
    });
  </script>

  <?php echo $__env->yieldPushContent('scripts'); ?>

  <script>
    window.addEventListener("pageshow", function(event) {
      if (event.persisted) {
        window.location.reload();
      }
    });
  </script>
</body>

</html><?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/layouts/app.blade.php ENDPATH**/ ?>