<?php if($paginator->hasPages()): ?>
<nav aria-label="Page navigation">
    <ul class="pagination justify-content-center">
        
        <?php if($paginator->onFirstPage()): ?>
            <li class="page-item disabled">
                <span class="page-link" aria-hidden="true">&laquo;</span>
            </li>
        <?php else: ?>
            <li class="page-item">
                <a class="page-link" href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" aria-label="Previous">&laquo;</a>
            </li>
        <?php endif; ?>

        
        <?php
            $start = max($paginator->currentPage() - 2, 1);
            $end = min($paginator->currentPage() + 2, $paginator->lastPage());
        ?>

        
        <?php if($start > 1): ?>
            <li class="page-item">
                <a class="page-link" href="<?php echo e($paginator->url(1)); ?>">1</a>
            </li>
            <?php if($start > 2): ?>
                <li class="page-item disabled"><span class="page-link">…</span></li>
            <?php endif; ?>
        <?php endif; ?>

        
        <?php for($page = $start; $page <= $end; $page++): ?>
            <?php if($page == $paginator->currentPage()): ?>
                <li class="page-item active" aria-current="page">
                    <span class="page-link"><?php echo e($page); ?></span>
                </li>
            <?php else: ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($paginator->url($page)); ?>"><?php echo e($page); ?></a>
                </li>
            <?php endif; ?>
        <?php endfor; ?>

        
        <?php if($end < $paginator->lastPage()): ?>
            <?php if($end < $paginator->lastPage() - 1): ?>
                <li class="page-item disabled"><span class="page-link">…</span></li>
            <?php endif; ?>
            <li class="page-item">
                <a class="page-link" href="<?php echo e($paginator->url($paginator->lastPage())); ?>"><?php echo e($paginator->lastPage()); ?></a>
            </li>
        <?php endif; ?>

        
        <?php if($paginator->hasMorePages()): ?>
            <li class="page-item">
                <a class="page-link" href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" aria-label="Next">&raquo;</a>
            </li>
        <?php else: ?>
            <li class="page-item disabled">
                <span class="page-link" aria-hidden="true">&raquo;</span>
            </li>
        <?php endif; ?>
    </ul>
</nav>

<div class="d-flex justify-content-center mt-2">
    <small class="text-muted">
        Menampilkan
        <strong><?php echo e($paginator->firstItem()); ?></strong>
        sampai
        <strong><?php echo e($paginator->lastItem()); ?></strong>
        dari
        <strong><?php echo e($paginator->total()); ?></strong>
        hasil
    </small>
</div>
<?php endif; ?>
<?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/vendor/pagination/custom.blade.php ENDPATH**/ ?>