<?php $__env->startSection('title', 'Manajemen Pengguna'); ?>

<?php $__env->startSection('content'); ?>
<style>
    tr.clickable-row {
        cursor: pointer;
    }

    tr.clickable-row:hover {
        background-color: #f8f9fa;
    }
</style>

<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title font-weight-bold">
                <i class="fas fa-users mr-2"></i> Manajemen Pengguna
            </h3>
        </div>

        <div class="card-body">
            <form method="GET" action="<?php echo e(route('pengguna.index')); ?>" class="row mb-3 align-items-center g-2">
                <div class="col-auto">
                    <?php if($canCreate): ?>
                    <a href="<?php echo e(route('pengguna.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Tambah
                    </a>
                    <?php endif; ?>
                </div>
                <div class="col"></div>
                <div class="col-auto">
                    <div class="input-group input-group-sm">
                        <input type="text" name="search" class="form-control" placeholder="Cari nama / username / email / role..."
                            value="<?php echo e(request('search')); ?>" style="width:280px;">
                        <div class="input-group-append">
                            <select name="per_page" class="form-control form-control-sm border-left-0" onchange="this.form.submit()" style="width:68px;">
                                <option value="40" <?php echo e(request('per_page',40)==40  ? 'selected':''); ?>>40</option>
                                <option value="50" <?php echo e(request('per_page')==50     ? 'selected':''); ?>>50</option>
                                <option value="100" <?php echo e(request('per_page')==100    ? 'selected':''); ?>>100</option>
                            </select>
                        </div>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th width="70" class="text-center">No</th>
                            <th>Nama</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th width="130" class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $penggunas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr <?php if($canEdit): ?> class="clickable-row" data-url="<?php echo e(route('pengguna.edit', $p)); ?>" <?php endif; ?>>
                            <td class="text-center"><?php echo e($penggunas->firstItem() + $i); ?></td>
                            <td><strong><?php echo e($p->nama); ?></strong></td>
                            <td><?php echo e($p->username); ?></td>
                            <td><?php echo e($p->email ?: '-'); ?></td>
                            <td><span class="badge badge-info"><?php echo e($p->role?->nama_role ?? 'Tidak ada'); ?></span></td>
                            <td class="text-center">
                                <?php if($canEdit): ?>
                                <a href="<?php echo e(route('pengguna.edit', $p)); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php endif; ?>
                                <?php if($canDelete): ?>
                                <form action="<?php echo e(route('pengguna.destroy', $p)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button type="button" class="btn btn-danger btn-sm delete-btn" data-nama="<?php echo e($p->nama); ?>">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-5">
                                <i class="fas fa-inbox fa-3x mb-3"></i><br>
                                Belum ada data pengguna.
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                <?php echo e($penggunas->appends(request()->query())->links('vendor.pagination.custom')); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function setupTable() {
        document.querySelectorAll('.clickable-row').forEach(row => row.onclick = null);
        document.querySelectorAll('.delete-btn').forEach(btn => btn.onclick = null);

        document.querySelectorAll('.clickable-row').forEach(row => {
            row.onclick = function(e) {
                if (e.target.closest('td:last-child')) return;
                if (e.target.closest('a, button')) return;
                window.location.href = this.dataset.url;
            };
        });

        document.querySelectorAll('.delete-btn').forEach(btn => {
            btn.onclick = function(e) {
                e.preventDefault();
                e.stopPropagation();
                const nama = this.dataset.nama;
                const form = this.closest('form');

                Swal.fire({
                    title: 'Yakin hapus?',
                    html: `Pengguna <strong>"${nama}"</strong> akan dihapus permanen!`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Ya, Hapus!',
                    cancelButtonText: 'Batal'
                }).then(result => {
                    if (result.isConfirmed) form.submit();
                });
            };
        });
    }

    document.addEventListener('DOMContentLoaded', setupTable);
    setInterval(setupTable, 400);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/pengguna/index.blade.php ENDPATH**/ ?>