
<?php $__env->startSection('title', 'Data Pasang Baru'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Data Pasang Baru</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('pasangbaru.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Tambah
                    </a>
                </div>
            </div>
            <div class="card-body">
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>

                <div class="row mb-3">
                    <div class="col-md-6 col-sm-12 mb-2 mb-md-0">
                        <form action="<?php echo e(route('pasangbaru.index')); ?>" method="GET" class="form-inline">
                            <label class="mr-2">Show</label>
                            <select name="limit" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                                <option value="40" <?php echo e(request('limit') == 40 ? 'selected' : ''); ?>>40</option>
                                <option value="50" <?php echo e(request('limit') == 50 ? 'selected' : ''); ?>>50</option>
                                <option value="100" <?php echo e(request('limit') == 100 ? 'selected' : ''); ?>>100</option>
                            </select>
                            <label>entries</label>
                        </form>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <form action="<?php echo e(route('pasangbaru.index')); ?>" method="GET" class="float-md-right">
                            <input type="hidden" name="limit" value="<?php echo e(request('limit', 40)); ?>">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="search" class="form-control" placeholder="Cari nama, alamat, HP, username, atau company..." value="<?php echo e(request('search')); ?>">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-nowrap">
                        <thead class="thead-light">
                            <tr>
                                <th style="width: 50px;">No</th>
                                <th>Nama</th>
                                <th>Username PPPoE</th>
                                <th>Alamat</th>
                                <th>HP</th>
                                <?php
                                    $user = Auth::user();
                                ?>
                                <?php if($user && $user->company_code === '000'): ?>
                                <th>Company</th>
                                <?php endif; ?>
                                <th>Status</th>
                                <th>Finish</th>
                                <th style="width: 120px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $pasangbarus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pasangbaru): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="clickable-row" data-href="<?php echo e(route('pasangbaru.show', $pasangbaru->id)); ?>" style="cursor: pointer;">
                                <td><?php echo e($loop->iteration + ($pasangbarus->currentPage() - 1) * $pasangbarus->perPage()); ?></td>
                                <td><?php echo e($pasangbaru->nama); ?></td>
                                <td><?php echo e($pasangbaru->username_pppoe); ?></td>
                                <td><?php echo e($pasangbaru->alamat); ?></td>
                                <td><?php echo e($pasangbaru->hp); ?></td>
                                <?php if($user && $user->company_code === '000'): ?>
                                <td><?php echo e($pasangbaru->company->nama_company ?? $pasangbaru->company_code); ?></td>
                                <?php endif; ?>
                                <td>
                                    <?php if($pasangbaru->status == 'active'): ?>
                                        <span class="badge badge-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($pasangbaru->finish == 'sudah'): ?>
                                        <span class="badge badge-success">Sudah</span>
                                    <?php elseif($pasangbaru->finish == 'belum'): ?>
                                        <span class="badge badge-warning">Belum</span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="action-btn" onclick="event.stopPropagation();">
                                    <?php if($pasangbaru->finish != 'sudah'): ?>
                                    <form action="<?php echo e(route('pasangbaru.finish', $pasangbaru->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Apakah Anda yakin ingin menyelesaikan data ini dan memindahkannya ke pelanggan?')">
                                            <i class="fas fa-check"></i> Finish
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('pasangbaru.edit', $pasangbaru->id)); ?>" class="btn btn-warning btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('pasangbaru.destroy', $pasangbaru->id)); ?>" method="POST" class="d-inline delete-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="button" class="btn btn-danger btn-sm btn-delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="<?php echo e($user && $user->company_code === '000' ? '8' : '7'); ?>" class="text-center">Data tidak ditemukan</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer clearfix">
                <?php echo e($pasangbarus->appends(['search' => request('search'), 'limit' => request('limit')])->links('vendor.pagination.custom')); ?>

            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Click row to navigate to show (except action column)
    document.querySelectorAll('.clickable-row').forEach(row => {
        row.addEventListener('click', function(e) {
            if (!e.target.closest('.action-btn')) {
                window.location = this.dataset.href;
            }
        });
    });

    // SweetAlert2 delete confirmation
    document.querySelectorAll('.btn-delete').forEach(button => {
        button.addEventListener('click', function() {
            let form = this.closest('form');
            Swal.fire({
                title: 'Apakah anda yakin?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\07. BillingNet\01\resources\views/pasangbaru/index.blade.php ENDPATH**/ ?>