<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\BackupDatabaseController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\PenggunaController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\MetodePembayaranController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PelangganController;
use App\Http\Controllers\PasangBaruController;
use App\Http\Controllers\PelaporanGangguanController;
use App\Http\Controllers\ImportDataPelangganController;

Route::get('/', function () {
    return redirect('/dashboard');
});

// Auth Routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
});
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/profile', [AuthController::class, 'editProfile'])->name('profile.edit');
Route::put('/profile', [AuthController::class, 'updateProfile'])->name('profile.update');

Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.index');

    Route::prefix('backupdatabase')->group(function () {
        Route::get('/', [BackupDatabaseController::class, 'index'])->name('backupdatabase.index');
        Route::get('/backup', [BackupDatabaseController::class, 'backup'])->name('backupdatabase.backup');
        Route::post('/restore', [BackupDatabaseController::class, 'restore'])->name('backupdatabase.restore');
        Route::get('/download/{fileName}', [BackupDatabaseController::class, 'download'])->name('backupdatabase.download');
        Route::delete('/delete/{fileName}', [BackupDatabaseController::class, 'destroy'])->name('backupdatabase.destroy');
    });

    Route::resource('role', RoleController::class)->except('show');
    Route::resource('company', CompanyController::class)->except('show');
    Route::resource('pengguna', PenggunaController::class)->except(['show']);
    Route::resource('metodepembayaran', MetodePembayaranController::class);
    Route::resource('product', ProductController::class)->except('show');
    Route::resource('pelanggan', PelangganController::class);
    Route::get('/importdatapelanggan', [ImportDataPelangganController::class, 'index'])->name('importdatapelanggan.index');
    Route::post('/importdatapelanggan', [ImportDataPelangganController::class, 'store'])->name('importdatapelanggan.store');
    Route::get('/importdatapelanggan/template', [ImportDataPelangganController::class, 'downloadTemplate'])->name('importdatapelanggan.template');

    Route::resource('pasangbaru', PasangBaruController::class);
    Route::post('/pasangbaru/{id}/finish', [PasangBaruController::class, 'finish'])->name('pasangbaru.finish');
    Route::post('/pelaporangangguan/{id}/finish', [PelaporanGangguanController::class, 'finish'])->name('pelaporangangguan.finish');
    Route::resource('pelaporangangguan', PelaporanGangguanController::class);
});
