@extends('layouts.app')

@section('title', 'Data Role')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Data Role</h3>
                <div class="card-tools">
                    @if($canCreate)
                    <a href="{{ route('role.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Tambah
                    </a>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <form action="{{ route('role.index') }}" method="GET" class="form-inline">
                            <label class="mr-2">Show</label>
                            <select name="limit" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                                <option value="40" {{ request('limit') == 40 ? 'selected' : '' }}>40</option>
                                <option value="50" {{ request('limit') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('limit') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                            <label>entries</label>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <form action="{{ route('role.index') }}" method="GET" class="float-right">
                            <input type="hidden" name="limit" value="{{ request('limit', 40) }}">
                            <div class="input-group input-group-sm" style="width: 250px;">
                                <input type="text" name="search" class="form-control float-right" placeholder="Search" value="{{ request('search') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Company</th>
                                <th>Nama Role</th>
                                <th>Keterangan</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($roles as $role)
                            <tr @if($canEdit) style="cursor: pointer;" onclick="if(!event.target.closest('.action-btn')) window.location='{{ route('role.edit', $role->id) }}';" @endif>
                                <td>{{ $loop->iteration + ($roles->currentPage() - 1) * $roles->perPage() }}</td>
                                <td>{{ $role->company->nama_company ?? $role->company_code }}</td>
                                <td>{{ $role->nama_role }}</td>
                                <td>{{ $role->keterangan }}</td>
                                <td class="action-btn">
                                    @if($canEdit)
                                    <a href="{{ route('role.edit', $role->id) }}" class="btn btn-warning btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @endif
                                    @if($canDelete)
                                    <form action="{{ route('role.destroy', $role->id) }}" method="POST" class="d-inline delete-form">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="btn btn-danger btn-sm btn-delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">Data tidak ditemukan</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer clearfix">
                {{ $roles->appends(['search' => request('search'), 'limit' => request('limit')])->links('vendor.pagination.custom') }}
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.querySelectorAll('.btn-delete').forEach(button => {
        button.addEventListener('click', function() {
            let form = this.closest('form');
            Swal.fire({
                title: 'Apakah anda yakin?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
@endsection