@extends('layouts.app')

@section('title', 'Tambah Role')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Form Tambah Role</h3>
            </div>
            <form action="{{ route('role.store') }}" method="POST">
                @csrf
                <div class="card-body">
                    <div class="form-group">
                        <label for="company_code">Company</label>
                        <select name="company_code" class="form-control @error('company_code') is-invalid @enderror" id="company_code">
                            <option value="">Pilih Company</option>
                            @foreach($companies as $company)
                            <option value="{{ $company->company_code }}" {{ old('company_code') == $company->company_code ? 'selected' : '' }}>
                                {{ $company->company_code }} - {{ $company->nama_company }}
                            </option>
                            @endforeach
                        </select>
                        @error('company_code')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="nama_role">Nama Role</label>
                        <input type="text" name="nama_role" class="form-control @error('nama_role') is-invalid @enderror" id="nama_role" value="{{ old('nama_role') }}" placeholder="Masukkan Nama Role">
                        @error('nama_role')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="keterangan">Keterangan</label>
                        <textarea name="keterangan" class="form-control @error('keterangan') is-invalid @enderror" id="keterangan" rows="3" placeholder="Masukkan Keterangan">{{ old('keterangan') }}</textarea>
                        @error('keterangan')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <hr>
                    <h5>Hak Akses Company</h5>
                    <div class="row">
                        @if(auth()->user()->company_code === '000')
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_company_cread" class="form-check-input" id="hak_akses_tbl_company_cread" value="1" {{ old('hak_akses_tbl_company_cread') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_company_cread">Create</label>
                            </div>
                        </div>
                        @else
                        <input type="hidden" name="hak_akses_tbl_company_cread" value="0">
                        @endif

                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_company_read" class="form-check-input" id="hak_akses_tbl_company_read" value="1" {{ old('hak_akses_tbl_company_read') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_company_read">Read</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_company_edit" class="form-check-input" id="hak_akses_tbl_company_edit" value="1" {{ old('hak_akses_tbl_company_edit') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_company_edit">Edit</label>
                            </div>
                        </div>

                        @if(auth()->user()->company_code === '000')
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_company_delete" class="form-check-input" id="hak_akses_tbl_company_delete" value="1" {{ old('hak_akses_tbl_company_delete') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_company_delete">Delete</label>
                            </div>
                        </div>
                        @else
                        <input type="hidden" name="hak_akses_tbl_company_delete" value="0">
                        @endif
                    </div>

                    <hr>
                    <h5>Hak Akses Role</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_role_cread" class="form-check-input" id="hak_akses_tbl_role_cread" value="1" {{ old('hak_akses_tbl_role_cread') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_role_cread">Create</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_role_read" class="form-check-input" id="hak_akses_tbl_role_read" value="1" {{ old('hak_akses_tbl_role_read') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_role_read">Read</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_role_edit" class="form-check-input" id="hak_akses_tbl_role_edit" value="1" {{ old('hak_akses_tbl_role_edit') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_role_edit">Edit</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_role_delete" class="form-check-input" id="hak_akses_tbl_role_delete" value="1" {{ old('hak_akses_tbl_role_delete') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_role_delete">Delete</label>
                            </div>
                        </div>
                    </div>

                    <hr>
                    <h5>Hak Akses Pengguna</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_pengguna_cread" class="form-check-input" id="hak_akses_tbl_pengguna_cread" value="1" {{ old('hak_akses_tbl_pengguna_cread') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_pengguna_cread">Create</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_pengguna_read" class="form-check-input" id="hak_akses_tbl_pengguna_read" value="1" {{ old('hak_akses_tbl_pengguna_read') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_pengguna_read">Read</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_pengguna_edit" class="form-check-input" id="hak_akses_tbl_pengguna_edit" value="1" {{ old('hak_akses_tbl_pengguna_edit') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_pengguna_edit">Edit</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input type="checkbox" name="hak_akses_tbl_pengguna_delete" class="form-check-input" id="hak_akses_tbl_pengguna_delete" value="1" {{ old('hak_akses_tbl_pengguna_delete') ? 'checked' : '' }}>
                                <label class="form-check-label" for="hak_akses_tbl_pengguna_delete">Delete</label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="{{ route('role.index') }}" class="btn btn-default">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection