{{-- resources/views/pengguna/edit.blade.php --}}
@extends('layouts.app')
@section('title', 'Edit Pengguna')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title font-weight-bold">
                <i class="fas fa-user-edit mr-2"></i>
                Edit Pengguna: {{ $pengguna->nama }}
            </h3>
        </div>

        <form action="{{ route('pengguna.update', $pengguna) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="card-body">
                <div class="row">
                    <!-- Kolom Kiri -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Company Code <span class="text-danger">*</span></label>
                            <select name="company_code" class="form-control @error('company_code') is-invalid @enderror" required>
                                <option value="">-- Pilih Company Code --</option>
                                @foreach($companies as $company)
                                <option value="{{ $company->company_code }}" {{ old('company_code', $pengguna->company_code) == $company->company_code ? 'selected' : '' }}>
                                    {{ $company->company_code }} - {{ $company->nama_company }}
                                </option>
                                @endforeach
                            </select>
                            @error('company_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" name="nama" class="form-control @error('nama') is-invalid @enderror"
                                value="{{ old('nama', $pengguna->nama) }}" required>
                            @error('nama')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Username <span class="text-danger">*</span></label>
                            <input type="text" name="username" class="form-control @error('username') is-invalid @enderror"
                                value="{{ old('username', $pengguna->username) }}" required>
                            @error('username')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                                value="{{ old('email', $pengguna->email) }}">
                            @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <!-- Kolom Kanan -->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Password Baru <small class="text-muted">(kosongkan jika tidak ingin mengganti)</small></label>
                            <input type="password" name="password" class="form-control @error('password') is-invalid @enderror"
                                placeholder="Minimal 6 karakter">
                            @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Konfirmasi Password Baru</label>
                            <input type="password" name="password_confirmation" class="form-control" placeholder="Ulangi password">
                        </div>

                        <div class="form-group">
                            <label>Role <span class="text-danger">*</span></label>
                            <select name="roleid" class="form-control @error('roleid') is-invalid @enderror" required>
                                <option value="">-- Pilih Role --</option>
                                @foreach($roles as $id => $nama_role)
                                <option value="{{ $id }}"
                                    {{ old('roleid', $pengguna->roleid) == $id ? 'selected' : '' }}>
                                    {{ $nama_role }}
                                </option>
                                @endforeach
                            </select>
                            @error('roleid')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>No. HP</label>
                            <input type="text" name="hp" class="form-control"
                                value="{{ old('hp', $pengguna->hp) }}" placeholder="Contoh: 08123456789">
                        </div>

                        <div class="form-group">
                            <label>Keterangan</label>
                            <textarea name="keterangan" class="form-control" rows="3"
                                placeholder="Opsional">{{ old('keterangan', $pengguna->keterangan) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update Pengguna
                </button>
                <a href="{{ route('pengguna.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </form>
    </div>
</div>
@endsection