@extends('layouts.app')
@section('title', 'Detail Pelaporan Gangguan')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Detail Pelaporan Gangguan</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Ticket</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->ticket }}</td>
                            </tr>
                            <tr>
                                <td><strong>Nama Pelanggan</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->nama }}</td>
                            </tr>
                            <tr>
                                <td><strong>Alamat</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->alamat }}</td>
                            </tr>
                            <tr>
                                <td><strong>No HP</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->hp }}</td>
                            </tr>
                            <tr>
                                <td><strong>Jenis Gangguan</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->jenis_gangguan ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Jam Gangguan</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->jam_ganguan ? \Carbon\Carbon::parse($pelaporanGangguan->jam_ganguan)->format('d-m-Y H:i') : '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Penerima Laporan</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->penerima_laporan ?? '-' }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Waktu Mulai Penanganan</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->waktu_mulai_penanganan ? \Carbon\Carbon::parse($pelaporanGangguan->waktu_mulai_penanganan)->format('d-m-Y H:i') : '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Petugas Teknisi</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->petugas_teknisi ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Waktu Selesai</strong></td>
                                <td>:</td>
                                <td>{{ $pelaporanGangguan->waktu_finish ? \Carbon\Carbon::parse($pelaporanGangguan->waktu_finish)->format('d-m-Y H:i') : '-' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><strong>Foto 1</strong></label>
                            @if($pelaporanGangguan->foto1)
                                <div>
                                    <img src="{{ asset('storage/' . $pelaporanGangguan->foto1) }}" alt="Foto 1" class="img-fluid img-thumbnail">
                                </div>
                            @else
                                <p class="text-muted">-</p>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><strong>Foto 2</strong></label>
                            @if($pelaporanGangguan->foto2)
                                <div>
                                    <img src="{{ asset('storage/' . $pelaporanGangguan->foto2) }}" alt="Foto 2" class="img-fluid img-thumbnail">
                                </div>
                            @else
                                <p class="text-muted">-</p>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label><strong>Keterangan</strong></label>
                            <p>{{ $pelaporanGangguan->keterangan ?? '-' }}</p>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <a href="{{ route('pelaporangangguan.index') }}" class="btn btn-secondary">Kembali</a>
                    <a href="{{ route('pelaporangangguan.edit', $pelaporanGangguan->id) }}" class="btn btn-warning">Edit</a>
                    
                    <form action="{{ route('pelaporangangguan.destroy', $pelaporanGangguan->id) }}" method="POST" class="d-inline delete-form">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-danger btn-delete">Hapus</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // SweetAlert2 delete confirmation
    document.querySelector('.btn-delete').addEventListener('click', function() {
        let form = this.closest('form');
        Swal.fire({
            title: 'Apakah anda yakin?',
            text: "Data yang dihapus tidak dapat dikembalikan!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, hapus!',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>
@endsection