@extends('layouts.app')
@section('title', 'Data Pelaporan Gangguan')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Data Pelaporan Gangguan</h3>
                <div class="card-tools">
                    <a href="{{ route('pelaporangangguan.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Tambah
                    </a>
                </div>
            </div>
            <div class="card-body">
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="row mb-3">
                    <div class="col-md-6 col-sm-12 mb-2 mb-md-0">
                        <form action="{{ route('pelaporangangguan.index') }}" method="GET" class="form-inline">
                            <label class="mr-2">Show</label>
                            <select name="limit" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                                <option value="40" {{ request('limit') == 40 ? 'selected' : '' }}>40</option>
                                <option value="50" {{ request('limit') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('limit') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                            <label>entries</label>
                        </form>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <form action="{{ route('pelaporangangguan.index') }}" method="GET" class="float-md-right">
                            <input type="hidden" name="limit" value="{{ request('limit', 40) }}">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="search" class="form-control" placeholder="Cari ticket, nama, alamat, HP, atau jenis gangguan..." value="{{ request('search') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-nowrap">
                        <thead class="thead-light">
                            <tr>
                                <th style="width: 50px;">No</th>
                                <th>Ticket</th>
                                <th>Nama</th>
                                <th>Alamat</th>
                                <th>HP</th>
                                <th>Jenis Gangguan</th>
                                <th>Tanggal Gangguan</th>
                                <th style="width: 120px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($pelaporanGangguans as $pelaporanGangguan)
                            <tr class="clickable-row" data-href="{{ route('pelaporangangguan.show', $pelaporanGangguan->id) }}" style="cursor: pointer;">
                                <td>{{ $loop->iteration + ($pelaporanGangguans->currentPage() - 1) * $pelaporanGangguans->perPage() }}</td>
                                <td>{{ $pelaporanGangguan->ticket }}</td>
                                <td>{{ $pelaporanGangguan->nama }}</td>
                                <td>{{ $pelaporanGangguan->alamat }}</td>
                                <td>{{ $pelaporanGangguan->hp }}</td>
                                <td>{{ $pelaporanGangguan->jenis_gangguan }}</td>
                                <td>{{ $pelaporanGangguan->jam_ganguan ? \Carbon\Carbon::parse($pelaporanGangguan->jam_ganguan)->format('d-m-Y H:i') : '-' }}</td>
                                <td class="action-btn" onclick="event.stopPropagation();">
                                    @if($pelaporanGangguan->finish != 1)
                                    <form action="{{ route('pelaporangangguan.finish', $pelaporanGangguan->id) }}" method="POST" class="d-inline finish-form">
                                        @csrf
                                        <button type="button" class="btn btn-success btn-sm btn-finish" title="Finish">
                                            <i class="fas fa-check"></i> Finish
                                        </button>
                                    </form>

                                    <a href="{{ route('pelaporangangguan.edit', $pelaporanGangguan->id) }}" class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('pelaporangangguan.destroy', $pelaporanGangguan->id) }}" method="POST" class="d-inline delete-form">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="btn btn-danger btn-sm btn-delete" title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center">Data tidak ditemukan</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer clearfix">
                {{ $pelaporanGangguans->appends(['search' => request('search'), 'limit' => request('limit')])->links('vendor.pagination.custom') }}
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Click row to navigate to show (except action column)
    document.querySelectorAll('.clickable-row').forEach(row => {
        row.addEventListener('click', function(e) {
            if (!e.target.closest('.action-btn')) {
                window.location = this.dataset.href;
            }
        });
    });

    // SweetAlert2 delete confirmation
    document.querySelectorAll('.btn-delete').forEach(button => {
        button.addEventListener('click', function() {
            let form = this.closest('form');
            Swal.fire({
                title: 'Apakah anda yakin?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });

    // SweetAlert2 finish confirmation
    document.querySelectorAll('.btn-finish').forEach(button => {
        button.addEventListener('click', function() {
            let form = this.closest('form');
            Swal.fire({
                title: 'Konfirmasi Finish',
                text: "Apakah anda yakin ingin menyelesaikan laporan ini?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, Finish!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
@endsection