@extends('layouts.app')
@section('title', 'Edit Pelaporan Gangguan')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Edit Pelaporan Gangguan</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('pelaporangangguan.update', $pelaporanGangguan->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="ticket">Ticket</label>
                                <input type="text" class="form-control" id="ticket" name="ticket" value="{{ old('ticket', $pelaporanGangguan->ticket) }}" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama">Nama Pelanggan *</label>
                                <select name="nama" id="nama" class="form-control select2" required disabled>
                                    <option value="">Pilih Pelanggan</option>
                                    @foreach($pelanggans as $pelanggan)
                                    <option value="{{ $pelanggan->nama }}"
                                        data-alamat="{{ $pelanggan->alamat ?? '' }}"
                                        data-hp="{{ $pelanggan->hp ?? '' }}"
                                        {{ old('nama', $pelaporanGangguan->nama) == $pelanggan->nama ? 'selected' : '' }}>
                                        {{ $pelanggan->nama }}
                                    </option>
                                    @endforeach
                                </select>

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="alamat">Alamat</label>
                                <input type="text" class="form-control" id="alamat" name="alamat" value="{{ old('alamat', $pelaporanGangguan->alamat) }}" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hp">No HP</label>
                                <input type="text" class="form-control" id="hp" name="hp" value="{{ old('hp', $pelaporanGangguan->hp) }}" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jenis_gangguan">Jenis Gangguan</label>
                                <textarea class="form-control" id="jenis_gangguan" name="jenis_gangguan" rows="3">{{ old('jenis_gangguan', $pelaporanGangguan->jenis_gangguan) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jam_ganguan">Jam Gangguan</label>
                                <input type="datetime-local" class="form-control" id="jam_ganguan" name="jam_ganguan" value="{{ old('jam_ganguan', $pelaporanGangguan->jam_ganguan ? \Carbon\Carbon::parse($pelaporanGangguan->jam_ganguan)->format('Y-m-d\TH:i') : '') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="penerima_laporan">Penerima Laporan</label>
                                <select name="penerima_laporan" id="penerima_laporan" class="form-control select2" disabled>
                                    <option value="">Pilih Penerima Laporan</option>
                                    @foreach($penerimaLaporans as $pengguna)
                                    <option value="{{ $pengguna->nama }}"
                                        {{ old('penerima_laporan', $pelaporanGangguan->penerima_laporan) == $pengguna->nama ? 'selected' : '' }}>
                                        {{ $pengguna->nama }}
                                    </option>
                                    @endforeach
                                </select>

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="waktu_mulai_penanganan">Waktu Mulai Penanganan</label>
                                <input type="datetime-local" class="form-control" id="waktu_mulai_penanganan" name="waktu_mulai_penanganan" value="{{ old('waktu_mulai_penanganan', $pelaporanGangguan->waktu_mulai_penanganan ? \Carbon\Carbon::parse($pelaporanGangguan->waktu_mulai_penanganan)->format('Y-m-d\TH:i') : '') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="petugas_teknisi">Petugas Teknisi</label>
                                <select name="petugas_teknisi" id="petugas_teknisi" class="form-control select2">
                                    <option value="">Pilih Teknisi</option>
                                    @foreach($teknisis as $teknisi)
                                    <option value="{{ $teknisi->nama }}" {{ old('petugas_teknisi', $pelaporanGangguan->petugas_teknisi) == $teknisi->nama ? 'selected' : '' }}>
                                        {{ $teknisi->nama }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="waktu_finish">Waktu Selesai</label>
                                <input type="datetime-local" class="form-control" id="waktu_finish" name="waktu_finish" value="{{ old('waktu_finish', $pelaporanGangguan->waktu_finish ? \Carbon\Carbon::parse($pelaporanGangguan->waktu_finish)->format('Y-m-d\TH:i') : '') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="foto1">Foto 1</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="foto1" name="foto1">
                                    <label class="custom-file-label" for="foto1">Pilih file</label>
                                </div>
                                @if($pelaporanGangguan->foto1)
                                <div class="mt-2">
                                    <img src="{{ asset('storage/' . $pelaporanGangguan->foto1) }}" alt="Foto 1" class="img-thumbnail" style="max-height: 150px;">
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="foto2">Foto 2</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="foto2" name="foto2">
                                    <label class="custom-file-label" for="foto2">Pilih file</label>
                                </div>
                                @if($pelaporanGangguan->foto2)
                                <div class="mt-2">
                                    <img src="{{ asset('storage/' . $pelaporanGangguan->foto2) }}" alt="Foto 2" class="img-thumbnail" style="max-height: 150px;">
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="keterangan">Keterangan</label>
                                <textarea class="form-control" id="keterangan" name="keterangan" rows="3">{{ old('keterangan', $pelaporanGangguan->keterangan) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                        <a href="{{ route('pelaporangangguan.index') }}" class="btn btn-secondary">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Select2 and Input File Label Scripts -->
@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize Select2
        $('.select2').select2({
            theme: 'bootstrap4'
        });

        // Update file label when file is selected
        $('.custom-file-input').change(function() {
            var fileName = $(this).val().split('\\').pop();
            $(this).next('.custom-file-label').addClass("selected").html(fileName);
        });

        // Function to update alamat and hp fields
        function updatePelangganFields() {
            var selectedOption = $('#nama').find('option:selected');
            // Use .attr() instead of .data() to get the raw attribute values
            var alamat = selectedOption.attr('data-alamat');
            var hp = selectedOption.attr('data-hp');

            $('#alamat').val(alamat ? alamat : '');
            $('#hp').val(hp ? hp : '');
        }

        // Handle regular change event
        $('#nama').on('change', function() {
            updatePelangganFields();
        });

        // Handle Select2 select event
        $('#nama').on('select2:select', function(e) {
            updatePelangganFields();
        });

        // If there's already a selected value, populate the fields on load
        if ($('#nama').val()) {
            updatePelangganFields();
        }
    });
</script>
@endpush
@endsection