@extends('layouts.app')
@section('title', 'Detail Pelanggan')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Detail Pelanggan</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th>Nama</th>
                                <td>{{ $pelanggan->nama }}</td>
                            </tr>
                            <tr>
                                <th>Alamat</th>
                                <td>{{ $pelanggan->alamat }}</td>
                            </tr>
                            <tr>
                                <th>HP</th>
                                <td>{{ $pelanggan->hp }}</td>
                            </tr>
                            <tr>
                                <th>Username PPPoE</th>
                                <td>{{ $pelanggan->username_pppoe }}</td>
                            </tr>
                            <tr>
                                <th>Password</th>
                                <td>{{ $pelanggan->password }}</td>
                            </tr>
                            <tr>
                                <th>Tanggal Pendaftaran</th>
                                <td>{{ $pelanggan->tgl_pendaftaran ? $pelanggan->tgl_pendaftaran->format('d/m/Y') : '-' }}</td>
                            </tr>
                            <tr>
                                <th>Tanggal Pasang</th>
                                <td>{{ $pelanggan->tgl_pasang ? $pelanggan->tgl_pasang->format('d/m/Y') : '-' }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <th>Tanggal Mulai Tagihan</th>
                                <td>{{ $pelanggan->tagihan_dimulai_tgl ? $pelanggan->tagihan_dimulai_tgl->format('d/m/Y') : '-' }}</td>
                            </tr>
                            <tr>
                                <th>Map</th>
                                <td>{{ $pelanggan->map ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Foto 1</th>
                                <td>
                                    @if($pelanggan->foto1)
                                        <a href="{{ asset('storage/' . $pelanggan->foto1) }}" target="_blank">
                                            <img src="{{ asset('storage/' . $pelanggan->foto1) }}" alt="Foto 1" style="max-width: 200px; max-height: 200px;">
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Foto 2</th>
                                <td>
                                    @if($pelanggan->foto2)
                                        <a href="{{ asset('storage/' . $pelanggan->foto2) }}" target="_blank">
                                            <img src="{{ asset('storage/' . $pelanggan->foto2) }}" alt="Foto 2" style="max-width: 200px; max-height: 200px;">
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Paket Product</th>
                                <td>{{ $pelanggan->product->nama ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Harga Paket</th>
                                <td>Rp {{ $pelanggan->product ? number_format($pelanggan->product->price, 0, ',', '.') : '-' }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($pelanggan->status == 'active')
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-secondary">Inactive</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Keterangan</th>
                                <td>{{ $pelanggan->keterangan ?? '-' }}</td>
                            </tr>
                            {{-- Hidden company_code field --}}
                            {{--<tr>
                                <th>Company</th>
                                <td>{{ $pelanggan->company->nama_company ?? $pelanggan->company_code }}</td>
                            </tr>--}}
                        </table>
                    </div>
                </div>

                @if($pelanggan->map)
                <div class="row mt-4">
                    <div class="col-12">
                        <h5>Lokasi Pelanggan</h5>
                        <div id="map-container" style="height: 400px; border: 1px solid #ddd; border-radius: 4px;"></div>
                    </div>
                </div>
                @endif

                <div class="form-group mt-4">
                    <a href="{{ route('pelanggan.edit', $pelanggan->id) }}" class="btn btn-warning">Edit</a>
                    <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary">Kembali</a>
                </div>
            </div>
        </div>
    </div>
</div>

@if($pelanggan->map)
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
<script>
    // Parse koordinat dari field map
    var mapValue = "{{ $pelanggan->map }}";
    var coords = mapValue.split(',').map(coord => parseFloat(coord.trim()));
    
    if (coords.length === 2 && !isNaN(coords[0]) && !isNaN(coords[1])) {
        // Inisialisasi peta dengan koordinat pelanggan
        var map = L.map('map-container').setView([coords[0], coords[1]], 15);

        // Tambahkan tile layer dari OpenStreetMap
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);

        // Tambahkan marker di lokasi pelanggan
        L.marker([coords[0], coords[1]]).addTo(map)
            .bindPopup('{{ $pelanggan->nama }}')
            .openPopup();
    }
</script>
@endif
@endsection