@extends('layouts.app')
@section('title', 'Data Pasang Baru')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Data Pasang Baru</h3>
                <div class="card-tools">
                    <a href="{{ route('pasangbaru.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> Tambah
                    </a>
                </div>
            </div>
            <div class="card-body">
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="row mb-3">
                    <div class="col-md-6 col-sm-12 mb-2 mb-md-0">
                        <form action="{{ route('pasangbaru.index') }}" method="GET" class="form-inline">
                            <label class="mr-2">Show</label>
                            <select name="limit" class="form-control form-control-sm mr-2" onchange="this.form.submit()">
                                <option value="40" {{ request('limit') == 40 ? 'selected' : '' }}>40</option>
                                <option value="50" {{ request('limit') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('limit') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                            <label>entries</label>
                        </form>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <form action="{{ route('pasangbaru.index') }}" method="GET" class="float-md-right">
                            <input type="hidden" name="limit" value="{{ request('limit', 40) }}">
                            <div class="input-group input-group-sm" style="width: 300px;">
                                <input type="text" name="search" class="form-control" placeholder="Cari nama, alamat, HP, username, atau company..." value="{{ request('search') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-default">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-nowrap">
                        <thead class="thead-light">
                            <tr>
                                <th style="width: 50px;">No</th>
                                <th>Nama</th>
                                <th>Username PPPoE</th>
                                <th>Alamat</th>
                                <th>HP</th>
                                @php
                                    $user = Auth::user();
                                @endphp
                                @if($user && $user->company_code === '000')
                                <th>Company</th>
                                @endif
                                <th>Status</th>
                                <th>Finish</th>
                                <th style="width: 120px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($pasangbarus as $pasangbaru)
                            <tr class="clickable-row" data-href="{{ route('pasangbaru.show', $pasangbaru->id) }}" style="cursor: pointer;">
                                <td>{{ $loop->iteration + ($pasangbarus->currentPage() - 1) * $pasangbarus->perPage() }}</td>
                                <td>{{ $pasangbaru->nama }}</td>
                                <td>{{ $pasangbaru->username_pppoe }}</td>
                                <td>{{ $pasangbaru->alamat }}</td>
                                <td>{{ $pasangbaru->hp }}</td>
                                @if($user && $user->company_code === '000')
                                <td>{{ $pasangbaru->company->nama_company ?? $pasangbaru->company_code }}</td>
                                @endif
                                <td>
                                    @if($pasangbaru->status == 'active')
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    @if($pasangbaru->finish == 'sudah')
                                        <span class="badge badge-success">Sudah</span>
                                    @elseif($pasangbaru->finish == 'belum')
                                        <span class="badge badge-warning">Belum</span>
                                    @else
                                        <span class="badge badge-secondary">-</span>
                                    @endif
                                </td>
                                <td class="action-btn" onclick="event.stopPropagation();">
                                    @if($pasangbaru->finish != 'sudah')
                                    <form action="{{ route('pasangbaru.finish', $pasangbaru->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Apakah Anda yakin ingin menyelesaikan data ini dan memindahkannya ke pelanggan?')">
                                            <i class="fas fa-check"></i> Finish
                                        </button>
                                    </form>
                                    @endif
                                    <a href="{{ route('pasangbaru.edit', $pasangbaru->id) }}" class="btn btn-warning btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('pasangbaru.destroy', $pasangbaru->id) }}" method="POST" class="d-inline delete-form">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="btn btn-danger btn-sm btn-delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="{{ $user && $user->company_code === '000' ? '8' : '7' }}" class="text-center">Data tidak ditemukan</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer clearfix">
                {{ $pasangbarus->appends(['search' => request('search'), 'limit' => request('limit')])->links('vendor.pagination.custom') }}
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Click row to navigate to show (except action column)
    document.querySelectorAll('.clickable-row').forEach(row => {
        row.addEventListener('click', function(e) {
            if (!e.target.closest('.action-btn')) {
                window.location = this.dataset.href;
            }
        });
    });

    // SweetAlert2 delete confirmation
    document.querySelectorAll('.btn-delete').forEach(button => {
        button.addEventListener('click', function() {
            let form = this.closest('form');
            Swal.fire({
                title: 'Apakah anda yakin?',
                text: "Data yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
@endsection