@extends('layouts.app')
@section('title', 'Edit Pasang Baru')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Edit Pasang Baru</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('pasangbaru.update', $pasangbaru->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama">Nama *</label>
                                <input type="text" class="form-control @error('nama') is-invalid @enderror" id="nama" name="nama" value="{{ old('nama', $pasangbaru->nama) }}" required maxlength="150">
                                @error('nama')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hp">HP *</label>
                                <input type="text" class="form-control @error('hp') is-invalid @enderror" id="hp" name="hp" value="{{ old('hp', $pasangbaru->hp) }}" required maxlength="20">
                                @error('hp')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="alamat">Alamat *</label>
                        <textarea class="form-control @error('alamat') is-invalid @enderror" id="alamat" name="alamat" rows="3" required>{{ old('alamat', $pasangbaru->alamat) }}</textarea>
                        @error('alamat')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="username_pppoe">Username PPPoE</label>
                                <input type="text" class="form-control @error('username_pppoe') is-invalid @enderror" id="username_pppoe" name="username_pppoe" value="{{ old('username_pppoe', $pasangbaru->username_pppoe) }}" maxlength="100">
                                @error('username_pppoe')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="text" class="form-control @error('password') is-invalid @enderror" id="password" name="password" value="{{ old('password', $pasangbaru->password) }}" maxlength="100">
                                @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="tgl_pendaftaran">Tanggal Pendaftaran *</label>
                                <input type="date" class="form-control @error('tgl_pendaftaran') is-invalid @enderror" id="tgl_pendaftaran" name="tgl_pendaftaran" value="{{ old('tgl_pendaftaran', $pasangbaru->tgl_pendaftaran ? $pasangbaru->tgl_pendaftaran->format('Y-m-d') : '') }}" required>
                                @error('tgl_pendaftaran')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="tgl_pasang">Tanggal Pasang</label>
                                <input type="date" class="form-control @error('tgl_pasang') is-invalid @enderror" id="tgl_pasang" name="tgl_pasang" value="{{ old('tgl_pasang', $pasangbaru->tgl_pasang ? $pasangbaru->tgl_pasang->format('Y-m-d') : '') }}">
                                @error('tgl_pasang')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="tagihan_dimulai_tgl">Tanggal Mulai Tagihan</label>
                                <input type="date" class="form-control @error('tagihan_dimulai_tgl') is-invalid @enderror" id="tagihan_dimulai_tgl" name="tagihan_dimulai_tgl" value="{{ old('tagihan_dimulai_tgl', $pasangbaru->tagihan_dimulai_tgl ? $pasangbaru->tagihan_dimulai_tgl->format('Y-m-d') : '') }}">
                                @error('tagihan_dimulai_tgl')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="paket_product">Paket Product *</label>
                                <select class="form-control @error('paket_product') is-invalid @enderror" id="paket_product" name="paket_product" required>
                                    <option value="">Pilih Paket</option>
                                    @foreach($products as $product)
                                    <option value="{{ $product->id }}" {{ old('paket_product', $pasangbaru->paket_product) == $product->id ? 'selected' : '' }}>
                                        {{ $product->nama }} - Rp {{ number_format($product->price, 0, ',', '.') }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('paket_product')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">Status *</label>
                                <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                    <option value="">Pilih Status</option>
                                    <option value="active" {{ old('status', $pasangbaru->status) == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ old('status', $pasangbaru->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                </select>
                                @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="map">Map</label>
                        <div class="input-group">
                            <input type="text" class="form-control @error('map') is-invalid @enderror" id="map" name="map" value="{{ old('map', $pasangbaru->map) }}" maxlength="255" placeholder="Latitude, Longitude">
                            <div class="input-group-append">
                                <button type="button" class="btn btn-info" id="btn-detect-location">
                                    <i class="fas fa-map-marker-alt"></i> Deteksi Lokasi
                                </button>
                            </div>
                        </div>
                        @error('map')
                        <div class="invalid-feedback" style="display: block;">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">Klik tombol "Deteksi Lokasi" atau klik pada peta di bawah.</small>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="foto1">Foto 1</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('foto1') is-invalid @enderror" id="foto1" name="foto1">
                                    <label class="custom-file-label" for="foto1">Pilih file</label>
                                </div>
                                @if($pasangbaru->foto1)
                                <div class="mt-2">
                                    <small class="text-muted">File saat ini:</small>
                                    <br>
                                    <a href="{{ asset('storage/' . $pasangbaru->foto1) }}" target="_blank">Lihat Foto 1</a>
                                </div>
                                @endif
                                @error('foto1')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Format: JPEG, PNG, JPG, GIF. Maksimal 2MB.</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="foto2">Foto 2</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('foto2') is-invalid @enderror" id="foto2" name="foto2">
                                    <label class="custom-file-label" for="foto2">Pilih file</label>
                                </div>
                                @if($pasangbaru->foto2)
                                <div class="mt-2">
                                    <small class="text-muted">File saat ini:</small>
                                    <br>
                                    <a href="{{ asset('storage/' . $pasangbaru->foto2) }}" target="_blank">Lihat Foto 2</a>
                                </div>
                                @endif
                                @error('foto2')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Format: JPEG, PNG, JPG, GIF. Maksimal 2MB.</small>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Peta Lokasi</label>
                        <div id="map-container" style="height: 400px; border: 1px solid #ddd; border-radius: 4px;"></div>
                        <small class="form-text text-muted">Klik pada peta untuk memilih lokasi pelanggan</small>
                    </div>

                    <div class="form-group">
                        <label for="finish">Finish</label>
                        <select class="form-control @error('finish') is-invalid @enderror" id="finish" name="finish">
                            <option value="">Pilih Status</option>
                            <option value="sudah" {{ old('finish', $pasangbaru->finish) == 'sudah' ? 'selected' : '' }}>Sudah</option>
                            <option value="belum" {{ old('finish', $pasangbaru->finish) == 'belum' ? 'selected' : '' }}>Belum</option>
                        </select>
                        @error('finish')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="keterangan">Keterangan</label>
                        <textarea class="form-control @error('keterangan') is-invalid @enderror" id="keterangan" name="keterangan" rows="3">{{ old('keterangan', $pasangbaru->keterangan) }}</textarea>
                        @error('keterangan')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- Hidden company_code field --}}
                    <input type="hidden" name="company_code" value="{{ $pasangbaru->company_code }}">

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="{{ route('pasangbaru.index') }}" class="btn btn-secondary">Batal</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // Inisialisasi peta dengan posisi default di sekitar kota Madiun
    var map = L.map('map-container').setView([-7.6298, 111.5239], 13);

    // Tambahkan tile layer dari OpenStreetMap
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(map);

    // Variabel untuk marker
    var marker = null;

    // Jika ada koordinat dalam field map, parse dan tampilkan marker
    var mapValue = document.getElementById('map').value;
    if (mapValue) {
        try {
            var coords = mapValue.split(',').map(coord => parseFloat(coord.trim()));
            if (coords.length === 2 && !isNaN(coords[0]) && !isNaN(coords[1])) {
                marker = L.marker([coords[0], coords[1]]).addTo(map);
                map.setView([coords[0], coords[1]], 15);
            }
        } catch (e) {
            console.error('Error parsing coordinates:', e);
        }
    }

    // Tambahkan event click pada peta
    map.on('click', function(e) {
        updateLocation(e.latlng.lat, e.latlng.lng);
    });

    // Fungsi untuk update lokasi dan marker
    function updateLocation(lat, lng) {
        // Hapus marker yang ada
        if (marker) {
            map.removeLayer(marker);
        }

        // Buat marker baru
        marker = L.marker([lat, lng]).addTo(map);

        // Update field input
        document.getElementById('map').value = lat + ', ' + lng;

        // Pan map ke lokasi
        map.panTo(new L.LatLng(lat, lng));
    }

    // Handle tombol deteksi lokasi
    document.getElementById('btn-detect-location').addEventListener('click', function() {
        if (navigator.geolocation) {
            // Tampilkan loading state jika perlu, misalnya ubah text tombol
            let btn = this;
            let originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Mencari...';
            btn.disabled = true;

            navigator.geolocation.getCurrentPosition(function(position) {
                updateLocation(position.coords.latitude, position.coords.longitude);

                // Reset tombol
                btn.innerHTML = originalText;
                btn.disabled = false;

                // Zoom in sedikit agar lebih jelas
                map.setView([position.coords.latitude, position.coords.longitude], 17);

                Swal.fire({
                    icon: 'success',
                    title: 'Lokasi Ditemukan',
                    text: 'Koordinat berhasil didapatkan dari GPS perangkat.',
                    timer: 1500,
                    showConfirmButton: false
                });
            }, function(error) {
                // Reset tombol
                btn.innerHTML = originalText;
                btn.disabled = false;

                console.error("Error Geolocation: ", error);
                let msg = "Gagal mendapatkan lokasi.";
                switch (error.code) {
                    case error.PERMISSION_DENIED:
                        msg = "Ijin lokasi ditolak oleh pengguna.";
                        break;
                    case error.POSITION_UNAVAILABLE:
                        msg = "Informasi lokasi tidak tersedia.";
                        break;
                    case error.TIMEOUT:
                        msg = "Waktu permintaan lokasi habis.";
                        break;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Gagal',
                    text: msg
                });
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: "Browser anda tidak mendukung Geolocation."
            });
        }
    });

    // Handle custom file input labels
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>
@endsection