@extends('layouts.app')
@section('title', 'Edit Metode Pembayaran')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-warning">
            <div class="card-header">
                <h3 class="card-title">Form Edit Metode Pembayaran</h3>
            </div>
            <form action="{{ route('metodepembayaran.update', $metodePembayaran->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="form-group">
                        <label for="metode_pembayaran">Metode Pembayaran</label>
                        <input type="text" name="metode_pembayaran" class="form-control @error('metode_pembayaran') is-invalid @enderror" id="metode_pembayaran" value="{{ old('metode_pembayaran', $metodePembayaran->metode_pembayaran) }}" placeholder="Masukkan Metode Pembayaran">
                        @error('metode_pembayaran')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="keterangan">Keterangan</label>
                        <textarea name="keterangan" class="form-control @error('keterangan') is-invalid @enderror" id="keterangan" rows="3" placeholder="Masukkan Keterangan">{{ old('keterangan', $metodePembayaran->keterangan) }}</textarea>
                        @error('keterangan')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-warning">Update</button>
                    <a href="{{ route('metodepembayaran.index') }}" class="btn btn-default">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection