<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="{{ url('/') }}" class="brand-link">
        <img src="{{ asset('adminlte/dist/img/AdminLTELogo.png') }}" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">BuildNet</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- User Panel -->
        @php
        $user = Auth::user();
        $companyName = 'Superadmin';
        $companyLogo = asset('/images/logo.jpg'); // Default logo

        if ($user && $user->company_code !== '000') {
        $company = \App\Models\Company::where('company_code', $user->company_code)->first();
        if ($company) {
        $companyName = $company->nama_company;
        if (!empty($company->logo)) {
        $companyLogo = asset('storage/' . $company->logo);
        }
        }
        }
        @endphp

        <div class="user-panel mt-3 pb-3 mb-3 d-flex align-items-center">
            <div class="image">
                <img src="{{ $companyLogo }}" class="img-circle elevation-2" alt="User Image" style="width: 38px; height: 38px; object-fit: cover;">
            </div>
            <div class="info">
                <a href="{{ route('profile.edit') }}" class="d-block font-weight-bold">{{ $user->nama ?? 'User' }}</a>
                <span class="text-xs text-muted d-block">{{ Str::limit($companyName, 20) }}</span>
            </div>
        </div>

        <!-- Sidebar Search Form -->
        <div class="form-inline">
            <form action="{{ route('pelanggan.index') }}" method="GET" class="w-100">
                <div class="input-group">
                    <input class="form-control form-control-sidebar" type="search" name="search" placeholder="Cari Pelanggan..." aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-sidebar" type="submit">
                            <i class="fas fa-search fa-fw"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column nav-flat nav-child-indent" data-widget="treeview" role="menu" data-accordion="false">

                <li class="nav-header">MENU UTAMA</li>

                <li class="nav-item">
                    <a href="{{ url('/dashboard') }}" class="nav-link {{ Request::is('dashboard') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p>
                    </a>
                </li>

                {{-- Permissions Checks --}}
                @php
                $canReadCompany = $user && ($user->company_code === '000' || ($user->role && $user->role->hak_akses_tbl_company_read));
                $canReadRole = $user && ($user->company_code === '000' || ($user->role && $user->role->hak_akses_tbl_role_read));
                $canReadPengguna = $user && ($user->company_code === '000' || ($user->role && $user->role->hak_akses_tbl_pengguna_read));
                @endphp

                <li class="nav-header">LAYANAN PELANGGAN</li>

                <li class="nav-item">
                    <a href="{{ route('pelanggan.index') }}" class="nav-link {{ request()->is('pelanggan*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-address-book"></i>
                        <p>Data Pelanggan</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ route('importdatapelanggan.index') }}" class="nav-link {{ request()->is('importdatapelanggan*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-file-import"></i>
                        <p>Import Pelanggan</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ route('pasangbaru.index') }}" class="nav-link {{ request()->is('pasangbaru*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-user-plus"></i>
                        <p>
                            Pasang Baru
                            @php
                            // Check for 'belum' status as currently used in DB for this model
                            $queryPasang = \App\Models\PasangBaru::where('finish', 'belum');

                            if ($user && $user->company_code !== '000') {
                            $queryPasang->where('company_code', $user->company_code);
                            }
                            $pendingPasangBaruCount = $queryPasang->count();
                            @endphp

                            @if($pendingPasangBaruCount > 0)
                            <span class="badge badge-warning right">{{ $pendingPasangBaruCount }}</span>
                            @endif
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ route('pelaporangangguan.index') }}" class="nav-link {{ request()->is('pelaporangangguan*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-headset"></i>
                        <p>
                            Pelaporan Gangguan
                            @php
                            $queryGangguan = \App\Models\PelaporanGangguan::where('finish', false);
                            if ($user && $user->company_code !== '000') {
                            $queryGangguan->where('company_code', $user->company_code);
                            }
                            $pendingGangguanCount = $queryGangguan->count();
                            @endphp

                            @if($pendingGangguanCount > 0)
                            <span class="badge badge-danger right">{{ $pendingGangguanCount }}</span>
                            @endif
                        </p>
                    </a>
                </li>

                <li class="nav-header">MASTER DATA</li>

                <li class="nav-item">
                    <a href="{{ route('product.index') }}" class="nav-link {{ request()->is('product*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-box-open"></i>
                        <p>Produk / Paket</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ route('metodepembayaran.index') }}" class="nav-link {{ request()->is('metodepembayaran*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-credit-card"></i>
                        <p>Metode Pembayaran</p>
                    </a>
                </li>

                @if($canReadCompany || $canReadRole || $canReadPengguna)
                <li class="nav-header">ADMINISTRASI SISTEM</li>

                @if($canReadCompany)
                <li class="nav-item">
                    <a href="{{ url('/company') }}" class="nav-link {{ Request::is('company*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-building"></i>
                        <p>Perusahaan</p>
                    </a>
                </li>
                @endif

                @if($canReadRole)
                <li class="nav-item">
                    <a href="{{ url('/role') }}" class="nav-link {{ Request::is('role*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-user-shield"></i>
                        <p>Manajemen Role</p>
                    </a>
                </li>
                @endif

                @if($canReadPengguna)
                <li class="nav-item">
                    <a href="{{ route('pengguna.index') }}" class="nav-link {{ request()->is('pengguna*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-users"></i>
                        <p>Pengguna</p>
                    </a>
                </li>
                @endif

                <li class="nav-item">
                    <a href="{{ url('/backupdatabase') }}" class="nav-link {{ Request::is('backupdatabase*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-database"></i>
                        <p>Backup & Restore</p>
                    </a>
                </li>
                @endif
            </ul>
        </nav>
    </div>
</aside>