<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a href="{{ url('/') }}" class="nav-link">Home</a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a href="#" class="nav-link">Contact</a>
        </li>
    </ul>

    <ul class="navbar-nav ml-auto">
        @auth
        @php
        $user = Auth::user();
        $pendingPasangBaruCount = 0;
        $pendingGangguanCount = 0;

        if ($user) {
        // Calc Pasang Baru
        $queryPasang = \App\Models\PasangBaru::where('finish', 'belum');
        if ($user->company_code !== '000') {
        $queryPasang->where('company_code', $user->company_code);
        }
        $pendingPasangBaruCount = $queryPasang->count();

        // Calc Gangguan
        $queryGangguan = \App\Models\PelaporanGangguan::where('finish', false);
        if ($user->company_code !== '000') {
        $queryGangguan->where('company_code', $user->company_code);
        }
        $pendingGangguanCount = $queryGangguan->count();
        }
        @endphp

        <!-- Notifications Dropdown Menu -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell"></i>
                @if($pendingPasangBaruCount + $pendingGangguanCount > 0)
                <span class="badge badge-danger navbar-badge">{{ $pendingPasangBaruCount + $pendingGangguanCount }}</span>
                @endif
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-item dropdown-header">{{ $pendingPasangBaruCount + $pendingGangguanCount }} Notifications</span>
                <div class="dropdown-divider"></div>

                @if($pendingPasangBaruCount > 0)
                <a href="{{ route('pasangbaru.index') }}" class="dropdown-item">
                    <i class="fas fa-user-plus mr-2"></i> {{ $pendingPasangBaruCount }} Pasang Baru
                </a>
                <div class="dropdown-divider"></div>
                @endif

                @if($pendingGangguanCount > 0)
                <a href="{{ route('pelaporangangguan.index') }}" class="dropdown-item">
                    <i class="fas fa-headset mr-2"></i> {{ $pendingGangguanCount }} Gangguan
                </a>
                <div class="dropdown-divider"></div>
                @endif
            </div>
        </li>

        <li class="nav-item dropdown">
            {{-- Tombol Dropdown (Icon User Only) --}}
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-user-circle"></i>
            </a>

            {{-- Isi Dropdown Menu --}}
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-item dropdown-header font-weight-bold">{{ Auth::user()->nama }}</span>
                <div class="dropdown-divider"></div>

                {{-- Link ke Profil --}}
                <a href="{{ route('profile.edit') }}" class="dropdown-item">
                    <i class="fas fa-user-cog mr-2"></i> Profil User
                </a>

                <div class="dropdown-divider"></div>

                {{-- Tombol Logout --}}
                <a href="{{ route('logout') }}" class="dropdown-item dropdown-footer"
                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                </a>

                {{-- Form untuk proses logout --}}
                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
            </div>
        </li>
        @endauth
    </ul>
</nav>