@extends('layouts.app')

@section('title', 'Import Data Pelanggan')

@section('content')


<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Upload File Excel</h3>
                    </div>
                    <form action="{{ route('importdatapelanggan.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            @if(session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                            @endif

                            <div class="form-group">
                                <label>Template Import</label><br>
                                <a href="{{ route('importdatapelanggan.template') }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-download"></i> Download Template .xlsx
                                </a>
                            </div>

                            <div class="form-group">
                                <label for="file">Pilih File Excel (.xlsx, .xls)</label>
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="file" name="file" required>
                                        <label class="custom-file-label" for="file">Choose file</label>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Pastikan format kolom urut: <br>
                                    Nama | Alamat | HP | ID Paket | Username | Password | Tgl Daftar | Tgl Pasang | Tgl Tagihan | Map | Status | Keterangan
                                </small>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-upload"></i> Import</button>
                            <a href="{{ route('pelanggan.index') }}" class="btn btn-default float-right">Kembali</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
    // Custom file input label script
    $(".custom-file-input").on("change", function() {
        var fileName = $(this).val().split("\\").pop();
        $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
    });
</script>
@endpush