@extends('layouts.app')

@section('title', 'Edit Company')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-warning card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-edit"></i> Form Edit Company
                </h3>
            </div>

            <form action="{{ route('company.update', $company->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div class="card-body">

                    <!-- COMPANY CODE (DISABLED + HIDDEN UNTUK TETAP TERKIRIM) -->
                    <div class="form-group">
                        <label for="company_code">Kode Company</label>
                        <input type="text" 
                               class="form-control" 
                               value="{{ old('company_code', $company->company_code) }}" 
                               disabled>
                        <!-- Hidden input agar tetap terkirim saat submit -->
                        <input type="hidden" name="company_code" value="{{ old('company_code', $company->company_code) }}">
                        <small class="text-muted">Kode company tidak dapat diubah.</small>
                    </div>

                    <div class="form-group">
                        <label for="nama_company">Nama Company</label>
                        <input type="text" name="nama_company" class="form-control @error('nama_company') is-invalid @enderror" 
                               id="nama_company" value="{{ old('nama_company', $company->nama_company) }}" placeholder="Masukkan Nama Company">
                        @error('nama_company')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" class="form-control @error('status') is-invalid @enderror" id="status">
                            <option value="">Pilih Status</option>
                            <option value="active" {{ old('status', $company->status) == 'active' ? 'selected' : '' }}>Aktif</option>
                            <option value="inactive" {{ old('status', $company->status) == 'inactive' ? 'selected' : '' }}>Non-Aktif</option>
                        </select>
                        @error('status')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="expired_at">Expired At</label>
                        <input type="date" name="expired_at" class="form-control @error('expired_at') is-invalid @enderror" 
                               id="expired_at" value="{{ old('expired_at', optional($company->expired_at)->format('Y-m-d')) }}">
                        @error('expired_at')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="logo">Logo</label>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" name="logo" class="custom-file-input @error('logo') is-invalid @enderror" id="logo">
                                <label class="custom-file-label" for="logo">Pilih file...</label>
                            </div>
                        </div>
                        @if($company->logo)
                            <div class="mt-2">
                                <img src="{{ asset('storage/' . $company->logo) }}" alt="Logo saat ini" class="img-thumbnail" width="120">
                                <small class="text-muted d-block">Logo saat ini</small>
                            </div>
                        @endif
                        @error('logo')
                            <span class="text-danger text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="alamat">Alamat</label>
                        <textarea name="alamat" class="form-control @error('alamat') is-invalid @enderror" 
                                  id="alamat" rows="4" placeholder="Masukkan Alamat">{{ old('alamat', $company->alamat) }}</textarea>
                        @error('alamat')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="hp">No. HP</label>
                        <input type="text" name="hp" class="form-control @error('hp') is-invalid @enderror" 
                               id="hp" value="{{ old('hp', $company->hp) }}" placeholder="Masukkan No HP">
                        @error('hp')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" 
                               id="email" value="{{ old('email', $company->email) }}" placeholder="Masukkan Email">
                        @error('email')
                            <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>

                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-save"></i> Update
                    </button>
                    <a href="{{ route('company.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

{{-- Optional: agar label file upload berubah sesuai file yang dipilih --}}
@push('scripts')
<script>
    $('#logo').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName || 'Pilih file...');
    });
</script>
@endpush