@extends('layouts.app')
@section('title', 'Backup & Restore Database')

@section('content')


<section class="content">
    <div class="container-fluid">

        @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-check"></i> Berhasil!</h5>
            {{ session('success') }}
        </div>
        @elseif(session('error'))
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-ban"></i> Error!</h5>
            {{ session('error') }}
        </div>
        @endif

        <div class="row">
            <!-- Left Column: Actions -->
            <div class="col-md-4">

                <!-- Backup Card -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-plus-circle mr-1"></i> Buat Backup Baru
                        </h3>
                    </div>
                    <div class="card-body">
                        <p class="text-muted text-sm">
                            Sistem akan membuat file cadangan <code>.sql</code> dari seluruh data database Anda (sesuai hak akses tenant) dan menyimpannya di server.
                        </p>
                        <a href="{{ route('backupdatabase.backup') }}" class="btn btn-primary btn-block">
                            <i class="fas fa-save mr-1"></i> Proses Backup Sekarang
                        </a>
                    </div>
                </div>

                <!-- Restore Card -->
                <div class="card card-danger card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-upload mr-1"></i> Restore Database
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning p-2">
                            <span class="text-xs">
                                <i class="fas fa-exclamation-triangle mr-1"></i>
                                <b>PERINGATAN:</b> Data saat ini akan DITIMPA/DIHAPUS sesuai isi file backup.
                            </span>
                        </div>

                        <form action="{{ route('backupdatabase.restore') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="sql_file">File Backup (.sql)</label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="sql_file" id="sql_file" accept=".sql" required>
                                    <label class="custom-file-label" for="sql_file">Pilih file...</label>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-danger btn-block" onclick="return confirm('APAKAH ANDA YAKIN? Data yang ada akan ditimpa dan tidak bisa dikembalikan!')">
                                <i class="fas fa-history mr-1"></i> Mulai Restore
                            </button>
                        </form>
                    </div>
                </div>

            </div>

            <!-- Right Column: History -->
            <div class="col-md-8">
                <div class="card card-secondary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-list-alt mr-1"></i> Riwayat Backup di Server
                        </h3>
                        <div class="card-tools">
                            <span class="badge badge-info">{{ count($files) }} File Tersimpan</span>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover table-striped">
                                <thead>
                                    <tr>
                                        <th>Nama File</th>
                                        <th class="text-center">Ukuran</th>
                                        <th class="text-center">Waktu Dibuat</th>
                                        <th class="text-right">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($files as $file)
                                    <tr>
                                        <td>
                                            <i class="far fa-file-code text-primary mr-1"></i>
                                            <span class="text-bold text-dark">{{ $file['name'] }}</span>
                                        </td>
                                        <td class="text-center"><span class="badge badge-light">{{ $file['size'] }}</span></td>
                                        <td class="text-center text-muted text-sm">{{ $file['date'] }}</td>
                                        <td class="text-right">
                                            <div class="btn-group">
                                                <a href="{{ route('backupdatabase.download', $file['name']) }}" class="btn btn-sm btn-info" title="Download">
                                                    <i class="fas fa-download"></i>
                                                </a>
                                                <form action="{{ route('backupdatabase.destroy', $file['name']) }}" method="POST" class="d-inline" onsubmit="return confirm('Hapus file backup ini dari server?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" class="btn btn-sm btn-danger" title="Hapus" onclick="$(this).closest('form').submit();">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="4" class="text-center py-5 text-muted">
                                            <i class="fas fa-box-open fa-3x mb-3"></i><br>
                                            Belum ada riwayat backup yang ditemukan.
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('scripts')
<script>
    // Show filename on custom file input change
    $(".custom-file-input").on("change", function() {
        var fileName = $(this).val().split("\\").pop();
        $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
    });
</script>
@endpush
@endsection