<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        try {
            // Fix collation mismatch for tbl_company
            DB::statement('ALTER TABLE tbl_company MODIFY company_code VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        } catch (\Exception $e) {
            // Log or ignore if table missing
        }

        try {
            // Fix collation mismatch for tbl_pelanggan
            DB::statement('ALTER TABLE tbl_pelanggan MODIFY company_code VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
        } catch (\Exception $e) {
            // Log or ignore
        }

        // Also fix for other tables just in case
        $tables = ['tbl_product', 'tbl_pasang_baru', 'tbl_pelaporan_gangguan', 'tbl_role', 'users'];
        foreach ($tables as $table) {
            try {
                DB::statement("ALTER TABLE {$table} MODIFY company_code VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            } catch (\Exception $e) {
                // Ignore if tables/columns don't exist
            }
        }

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // No simple reverse
    }
};
