<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('tbl_pelaporan_gangguan')) {
            if (!Schema::hasColumn('tbl_pelaporan_gangguan', 'company_code')) {
                // Using raw SQL to ensure it works without typical Schema builder issues
                DB::statement('ALTER TABLE tbl_pelaporan_gangguan ADD COLUMN company_code VARCHAR(20) NULL AFTER id');

                // Add index separately
                try {
                    DB::statement('CREATE INDEX tbl_pelaporan_gangguan_company_code_index ON tbl_pelaporan_gangguan (company_code)');
                } catch (\Exception $e) {
                    // Index might already exist or fail, ignore
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('tbl_pelaporan_gangguan')) {
            if (Schema::hasColumn('tbl_pelaporan_gangguan', 'company_code')) {
                DB::statement('ALTER TABLE tbl_pelaporan_gangguan DROP COLUMN company_code');
            }
        }
    }
};
