<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_metode_pembayaran', function (Blueprint $table) {
            $table->id();
            $table->string('company_code', 20)->index(); // Added index for better performance
            $table->string('metode_pembayaran', 100);
            $table->text('keterangan')->nullable();
            $table->timestamps();

            // Optional: Foreign key constraint if desired, but sticking to basic requirement first
            // $table->foreign('company_code')->references('company_code')->on('tbl_company')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_metode_pembayaran');
    }
};
