<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_role', function (Blueprint $table) {
            $table->boolean('hak_akses_tbl_company_edit')->default(0)->after('hak_akses_tbl_company_read');
            $table->boolean('hak_akses_tbl_role_edit')->default(0)->after('hak_akses_tbl_role_read');
            $table->boolean('hak_akses_tbl_pengguna_edit')->default(0)->after('hak_akses_tbl_pengguna_read');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_role', function (Blueprint $table) {
            $table->dropColumn('hak_akses_tbl_company_edit');
            $table->dropColumn('hak_akses_tbl_role_edit');
            $table->dropColumn('hak_akses_tbl_pengguna_edit');
        });
    }
};
