<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_company', function (Blueprint $table) {
            $table->id();
            $table->string('company_code')->unique();
            $table->string('nama_company');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->date('expired_at')->nullable();
            $table->string('logo')->nullable();
            $table->text('alamat')->nullable();
            $table->string('hp')->nullable();
            $table->string('email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_company');
    }
};
