<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_pengguna', function (Blueprint $table) {
            $table->id();
            $table->string('company_code', 50);
            $table->string('nama', 100);
            $table->string('username', 50)->unique();
            $table->string('password');
            $table->string('email', 100)->nullable()->unique();
            $table->unsignedBigInteger('roleid')->nullable();
            $table->string('hp', 20)->nullable();
            $table->text('keterangan')->nullable();
            $table->rememberToken();
            $table->timestamps();

            $table->index(['nama', 'username', 'email', 'hp']);
        });

        Schema::table('tbl_pengguna', function (Blueprint $table) {
            $table->foreign('company_code')
                ->references('company_code')->on('tbl_company')
                ->cascadeOnUpdate()
                ->restrictOnDelete();

            $table->foreign('roleid')
                ->references('id')->on('tbl_role')
                ->cascadeOnUpdate()
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_pengguna');
    }
};

