<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_role', function (Blueprint $table) {
            $table->id();
            $table->string('company_code', 50);
            $table->string('nama_role', 100);
            $table->text('keterangan')->nullable();

            // Hak Akses Company
            $table->boolean('hak_akses_tbl_company_cread')->default(0);
            $table->boolean('hak_akses_tbl_company_read')->default(0);
            $table->boolean('hak_akses_tbl_company_delete')->default(0);

            // Hak Akses Role
            $table->boolean('hak_akses_tbl_role_cread')->default(0);
            $table->boolean('hak_akses_tbl_role_read')->default(0);
            $table->boolean('hak_akses_tbl_role_delete')->default(0);

            // Hak Akses Pengguna
            $table->boolean('hak_akses_tbl_pengguna_cread')->default(0);
            $table->boolean('hak_akses_tbl_pengguna_read')->default(0);
            $table->boolean('hak_akses_tbl_pengguna_delete')->default(0);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tbl_role');
    }
};
