<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use SoftDeletes;
    protected $table = 'tbl_role';

    protected $fillable = [
        'company_code',
        'nama_role',
        'keterangan',
        'hak_akses_tbl_company_cread',
        'hak_akses_tbl_company_read',
        'hak_akses_tbl_company_edit',
        'hak_akses_tbl_company_delete',
        'hak_akses_tbl_role_cread',
        'hak_akses_tbl_role_read',
        'hak_akses_tbl_role_edit',
        'hak_akses_tbl_role_delete',
        'hak_akses_tbl_pengguna_cread',
        'hak_akses_tbl_pengguna_read',
        'hak_akses_tbl_pengguna_edit',
        'hak_akses_tbl_pengguna_delete',
    ];

    protected $casts = [
        'hak_akses_tbl_company_cread' => 'boolean',
        'hak_akses_tbl_company_read' => 'boolean',
        'hak_akses_tbl_company_edit' => 'boolean',
        'hak_akses_tbl_company_delete' => 'boolean',
        'hak_akses_tbl_role_cread' => 'boolean',
        'hak_akses_tbl_role_read' => 'boolean',
        'hak_akses_tbl_role_edit' => 'boolean',
        'hak_akses_tbl_role_delete' => 'boolean',
        'hak_akses_tbl_pengguna_cread' => 'boolean',
        'hak_akses_tbl_pengguna_read' => 'boolean',
        'hak_akses_tbl_pengguna_edit' => 'boolean',
        'hak_akses_tbl_pengguna_delete' => 'boolean',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_code', 'company_code');
    }
}
