<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes; // Add this line
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Pengguna extends Authenticatable
{
    use HasFactory, Notifiable, SoftDeletes; // Add SoftDeletes here

    protected $table = 'tbl_pengguna'; // nama tabel eksplisit

    protected $fillable = [
        'company_code',
        'nama',
        'username',
        'password',
        'email',
        'roleid',
        'hp',
        'keterangan',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'password' => 'hashed', // Laravel 10+ otomatis hash password
        ];
    }

    // Relasi ke Role
    public function role()
    {
        return $this->belongsTo(Role::class, 'roleid', 'id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_code', 'company_code');
    }

    // Optional: accessor untuk nama role langsung
    public function getRoleNamaAttribute()
    {
        return $this->role?->nama ?? 'Tidak ada role';
    }
}
