<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class PelaporanGangguan extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'tbl_pelaporan_gangguan';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'ticket',
        'nama',
        'alamat',
        'hp',
        'jenis_gangguan',
        'jam_ganguan',
        'penerima_laporan',
        'waktu_mulai_penanganan',
        'petugas_teknisi',
        'waktu_finish',
        'foto1',
        'foto2',
        'keterangan',
        'company_code',
        'finish', // <-- DITAMBAHKAN
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'jam_ganguan' => 'datetime',
        'waktu_mulai_penanganan' => 'datetime',
        'waktu_finish' => 'datetime',
        'finish' => 'boolean', // <-- DITAMBAHKAN
    ];

    /**
     * Boot the model.
     */
    protected static function boot()
    {
        parent::boot();

        // Auto-fill company_code from logged-in user when creating
        static::creating(function ($model) {
            if (empty($model->company_code) && Auth::check()) {
                $model->company_code = Auth::user()->company_code;
            }
        });
    }

    /**
     * Get the company that owns the pelaporan gangguan.
     */
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_code', 'company_code');
    }
}
