<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Pelanggan extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'tbl_pelanggan';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nama',
        'alamat',
        'hp',
        'paket_product',
        'username_pppoe',
        'password',
        'tgl_pendaftaran',
        'tgl_pasang',
        'tagihan_dimulai_tgl',
        'map',
        'foto1',
        'foto2',
        'status',
        'keterangan',
        'company_code',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'tgl_pendaftaran' => 'date',
        'tgl_pasang' => 'date',
        'tagihan_dimulai_tgl' => 'date',
        'status' => 'string',
    ];

    /**
     * Boot the model.
     */
    protected static function boot()
    {
        parent::boot();

        // Auto-fill company_code from logged-in user when creating
        static::creating(function ($model) {
            if (empty($model->company_code) && Auth::check()) {
                $model->company_code = Auth::user()->company_code;
            }
        });
    }

    /**
     * Get the company that owns the pelanggan.
     */
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_code', 'company_code');
    }

    /**
     * Get the product associated with the pelanggan.
     */
    public function product()
    {
        return $this->belongsTo(Product::class, 'paket_product', 'id');
    }
}
