<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class MetodePembayaran extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'tbl_metode_pembayaran';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'company_code',
        'metode_pembayaran',
        'keterangan',
    ];

    /**
     * The "booted" method of the model.
     */
    protected static function booted()
    {
        static::creating(function ($model) {
            if (empty($model->company_code) && Auth::check()) {
                $user = Auth::user();
                $model->company_code = $user->company_code;
            }
        });
    }

    /**
     * Get the company that owns the metode pembayaran.
     */
    public function company()
    {
        return $this->belongsTo(Company::class, 'company_code', 'company_code');
    }
}
