<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use App\Models\Company;

class CheckCompanyStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        // If user is logged in
        if ($user) {
            // Bypass for Superadmin
            if ($user->company_code === '000') {
                return $next($request);
            }

            // Check Company Status
            $company = Company::where('company_code', $user->company_code)->first();

            if ($company) {
                // Check if status is Inactive (case insensitive)
                if (strcasecmp($company->status, 'inactive') === 0 || strcasecmp($company->status, 'nonaktif') === 0) {
                    abort(403, 'Perusahaan status inactive.... Hubungi layanan pengembang 082334110259');
                }
            }
        }

        return $next($request);
    }
}
