<?php

namespace App\Http\Controllers;

use App\Models\Pengguna;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function showLoginForm()
    {
        $breadcrumb = [
            ['name' => 'Login', 'url' => '']
        ];
        return view('auth.login', compact('breadcrumb'));
    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => 'required|string',
            'company_code' => 'required|string',
            'password' => 'required|string',
        ]);

        $user = Pengguna::where('username', $request->username)
            ->where('company_code', $request->company_code)
            ->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return back()->withErrors(['login' => 'Username / company code / password tidak valid'])->withInput();
        }

        Auth::login($user, $request->boolean('remember'));
        $request->session()->put('company_code', $user->company_code);
        return redirect()->intended(route('dashboard.index'));
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('login');
    }

    public function editProfile()
    {
        $breadcrumb = [
            ['name' => 'Dashboard', 'url' => route('dashboard.index')],
            ['name' => 'Profil Pengguna', 'url' => ''],
        ];
        $user = Auth::user();
        return view('auth.profile', compact('breadcrumb', 'user'));
    }

    public function updateProfile(Request $request)
    {
        $request->validate([
            'hp' => 'nullable|string|max:20',
            'password' => 'nullable|string|min:6|confirmed',
        ]);

        $user = Auth::user();

        // Update HP
        if ($request->filled('hp')) {
            $user->hp = $request->hp;
        }

        // Update Password if provided
        if ($request->filled('password')) {
            $user->password = Hash::make($request->password);
        }

        $user->save();

        return redirect()->route('dashboard.index')->with('success', 'Profil berhasil diperbarui');
    }
}
